/*
 * Decompiled with CFR 0.152.
 */
package docsynch.gui.jedit;

import docsynch.DocSynch;
import docsynch.DocSynchListener;
import docsynch.external.Log;
import docsynch.external.jedit.jEditBuffer;
import docsynch.external.jedit.jEditEditor;
import docsynch.gui.DocSynchGUIListener;
import docsynch.gui.jedit.BufferComboBoxRenderer;
import docsynch.gui.jedit.ColorDocumentTableCellRenderer;
import docsynch.gui.jedit.ColorTableCellRenderer;
import docsynch.gui.jedit.DocTableModel;
import docsynch.gui.jedit.UserTableModel;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;

public class DocSynchWindow
extends JPanel
implements DocSynchListener,
DocSynchGUIListener,
EBComponent,
TableModelListener {
    protected View view;
    protected String position;
    protected DocSynch ds;
    protected JLabel statuslabel;
    protected JComboBox bufferbox;
    protected JButton addbufferbutton;
    protected JButton addallbuffersbutton;
    protected JButton removebufferbutton;
    protected JButton startbutton;
    protected JButton requestbutton;
    protected JProgressBar progressBar;
    protected JLabel blockingLabel;
    protected JLabel lockModeIconLabel;
    protected JComboBox lockModeBox;
    protected JTable doctable;
    protected JTable usertable;
    protected DocTableModel doctableModel;
    protected UserTableModel usertableModel;
    protected Icon aquireMutexIcon;
    protected Icon releaseMutexIcon;
    protected Color normal_color;
    static /* synthetic */ Class class$docsynch$gui$jedit$DocSynchWindow;

    public DocSynchWindow(View view, String position, DocSynch ds) {
        this.view = view;
        this.position = position;
        this.ds = ds;
        EditBus.addToBus((EBComponent)this);
        if (ds != null) {
            ds.addGUIListener((DocSynchGUIListener)this);
            ds.addListener((DocSynchListener)this);
        }
        this.createMainPanel();
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof BufferUpdate) {
            BufferUpdate bu = (BufferUpdate)msg;
            if (bu.getWhat() == BufferUpdate.CREATED) {
                this.bufferbox.addItem(bu.getBuffer());
            } else if (bu.getWhat() == BufferUpdate.CLOSED) {
                this.bufferbox.removeItem(bu.getBuffer());
            }
        } else if (msg instanceof PropertiesChanged) {
            this.usertable.repaint();
        }
    }

    public void focusOnDefaultComponent() {
        this.bufferbox.requestFocus();
    }

    public boolean requestDefaultFocus() {
        this.focusOnDefaultComponent();
        return true;
    }

    protected void createMainPanel() {
        double[][] size = new double[][]{{10.0, -1.0, 10.0}, {5.0, -1.0, 5.0, 55.0, 5.0, -1.0, 5.0, 25.0, 5.0, 55.0, 5.0}};
        TableLayout layout = new TableLayout(size);
        this.setLayout(layout);
        int layoutY = 1;
        JPanel sessionPanel = this.createSessionPanel();
        this.add((Component)sessionPanel, "0, " + layoutY + ", 2, " + layoutY);
        JPanel lockModePanel = this.createLockModePanel();
        this.add((Component)lockModePanel, "0, " + (layoutY += 2) + ", 2, " + layoutY);
        JPanel docPanel = this.createDocPanel();
        this.add((Component)docPanel, "0, " + (layoutY += 2) + ", 2, " + layoutY);
        layoutY += 2;
        this.blockingLabel = new JLabel();
        this.blockingLabel.setOpaque(true);
        this.blockingLabel.setHorizontalAlignment(0);
        this.blockingLabel.setText(jEdit.getProperty((String)"docsynch.strings.blocking.off"));
        this.blockingLabel.setToolTipText(jEdit.getProperty((String)"docsynch.strings.blockinglabel.tooltip", (String)"_blockinglabel tooltip_"));
        this.add((Component)this.blockingLabel, "1, " + layoutY + ", 1, " + layoutY);
        JPanel progressPanel = this.createProgressPanel();
        this.add((Component)progressPanel, "0, " + (layoutY += 2) + ", 2, " + layoutY);
        try {
            this.connectionStatusChanged();
        }
        catch (NullPointerException npe) {
            Log.debug((Object)this, (String)("Error getting current DocSynch status to draw Window:\n" + npe));
        }
    }

    protected JPanel createStatusPanel() {
        double[][] size = new double[][]{{40.0, 10.0, -1.0}, {-1.0}};
        TableLayout layout = new TableLayout(size);
        JPanel panel = new JPanel(layout);
        JLabel labelone = new JLabel();
        labelone.setText(jEdit.getProperty((String)"docsynch.strings.statuslabel.caption", (String)"_status_"));
        labelone.setToolTipText(jEdit.getProperty((String)"docsynch.strings.statuslabel.tooltip", (String)"_status tooltip_"));
        panel.add((Component)labelone, "0, 0, r, f");
        this.statuslabel = new JLabel();
        this.normal_color = this.statuslabel.getBackground();
        this.statuslabel.setOpaque(true);
        this.statuslabel.setHorizontalAlignment(0);
        this.statuslabel.setToolTipText(jEdit.getProperty((String)"docsynch.strings.statuslabel.tooltip", (String)"_status tooltip_"));
        panel.add((Component)this.statuslabel, "2, 0, f, f");
        return panel;
    }

    protected JPanel createStartButtonPanel() {
        double[][] size = new double[][]{{-1.0}, {-1.0}};
        TableLayout layout = new TableLayout(size);
        JPanel panel = new JPanel(layout);
        this.startbutton = new JButton();
        this.startbutton.setText(jEdit.getProperty((String)"docsynch.strings.startbutton.start.caption", (String)"_start_"));
        this.startbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.startbutton.start.tooltip", (String)"_start tooltip_"));
        this.startbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DocSynchWindow.this.startbuttonActionPerformed(event);
            }
        });
        panel.add((Component)this.startbutton, "0, 0, f, f");
        return panel;
    }

    protected JPanel createSessionPanel() {
        double[][] size = new double[][]{{5.0, -1.0, 5.0}, {5.0, 25.0, 5.0, -1.0, 5.0, 25.0, 5.0}};
        TableLayout layout = new TableLayout(size);
        JPanel panel = new JPanel(layout);
        JPanel panel2 = this.createStartButtonPanel();
        panel.add((Component)panel2, "1, 5, 1, 5");
        JPanel panel1 = this.createStatusPanel();
        panel.add((Component)panel1, "1, 1, 1, 1");
        this.usertableModel = new UserTableModel(this.ds.getUsers());
        this.usertableModel.addTableModelListener(this);
        this.usertable = new JTable(this.usertableModel);
        this.usertable.getTableHeader().setReorderingAllowed(false);
        this.usertable.setRowSelectionAllowed(false);
        this.usertable.setColumnSelectionAllowed(false);
        ColorTableCellRenderer colorCellRenderer = new ColorTableCellRenderer(this.ds);
        for (int i = 0; i < this.usertable.getModel().getColumnCount(); ++i) {
            this.usertable.getColumnModel().getColumn(i).setCellRenderer(colorCellRenderer);
        }
        JScrollPane scrollPane2 = new JScrollPane(this.usertable);
        scrollPane2.setToolTipText(jEdit.getProperty((String)"docsynch.strings.userlist.tooltip", (String)"_userlist tooltip_"));
        panel.add((Component)scrollPane2, "1, 3, 1, 3");
        TitledBorder title = BorderFactory.createTitledBorder(jEdit.getProperty((String)"docsynch.strings.sessionpanel.title", (String)"_session_"));
        panel.setBorder(title);
        return panel;
    }

    protected JPanel createLockModePanel() {
        double[][] size = new double[][]{{5.0, 25.0, 10.0, -1.0, 5.0}, {5.0, -1.0, 5.0}};
        TableLayout layout = new TableLayout(size);
        JPanel panel = new JPanel(layout);
        JLabel lockModeIconLabel = new JLabel();
        panel.add((Component)lockModeIconLabel, "1, 1");
        this.lockModeBox = new JComboBox();
        this.lockModeBox.setEditable(false);
        this.lockModeBox.addItem(new LockModeComboBoxItem(this.ds, 1));
        this.lockModeBox.addItem(new LockModeComboBoxItem(this.ds, 2));
        this.lockModeBox.addItem(new LockModeComboBoxItem(this.ds, 3));
        this.lockModeBox.addItem(new LockModeComboBoxItem(this.ds, 0));
        this.lockModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DocSynchWindow.this.lockmodeboxitemclicked(event);
            }
        });
        panel.add((Component)this.lockModeBox, "3, 1");
        TitledBorder title = BorderFactory.createTitledBorder(jEdit.getProperty((String)"docsynch.strings.lockmodepanel.title", (String)"_lockmode_"));
        panel.setBorder(title);
        return panel;
    }

    protected JPanel createDocPanel() {
        double[][] size = new double[][]{{5.0, -1.0, 10.0, -1.0, 10.0, -1.0, 10.0, -1.0, 5.0}, {5.0, 25.0, 5.0, 25.0, 5.0, -1.0, 5.0}};
        TableLayout layout = new TableLayout(size);
        JPanel panel = new JPanel(layout);
        this.bufferbox = new JComboBox();
        BufferComboBoxRenderer renderer = new BufferComboBoxRenderer();
        this.bufferbox.setRenderer(renderer);
        this.bufferbox.setToolTipText(jEdit.getProperty((String)"docsynch.strings.bufferbox.tooltip", (String)"_bufferbox tooltip_"));
        this.bufferbox.updateUI();
        panel.add((Component)this.bufferbox, "1, 1, 7, 1");
        Buffer[] initial_buffers = jEdit.getBuffers();
        for (int i = 0; i < initial_buffers.length; ++i) {
            this.bufferbox.addItem(initial_buffers[i]);
        }
        this.aquireMutexIcon = this.loadIcon("docsynch.icons.aquiremutex");
        this.releaseMutexIcon = this.loadIcon("docsynch.icons.releasemutex");
        this.requestbutton = new JButton();
        this.requestbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.requestbutton.tooltip", (String)"_request tooltip_"));
        this.requestbutton.setIcon(this.aquireMutexIcon);
        this.requestbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DocSynchWindow.this.requestbuttonActionPerformed(event);
            }
        });
        panel.add((Component)this.requestbutton, "1, 3, f, f");
        this.addbufferbutton = new JButton();
        this.addbufferbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.addbutton.tooltip", (String)"_add tooltip_"));
        this.addbufferbutton.setIcon(this.loadIcon("docsynch.icons.adddoc"));
        this.addbufferbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DocSynchWindow.this.addbufferbuttonActionPerformed(event);
            }
        });
        panel.add((Component)this.addbufferbutton, "3, 3, f, f");
        this.addallbuffersbutton = new JButton();
        this.addallbuffersbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.addallbutton.tooltip", (String)"_add all tooltip_"));
        this.addallbuffersbutton.setIcon(this.loadIcon("docsynch.icons.addalldoc"));
        this.addallbuffersbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DocSynchWindow.this.addallbuffersbuttonActionPerformed(event);
            }
        });
        panel.add((Component)this.addallbuffersbutton, "5, 3, f, f");
        this.removebufferbutton = new JButton();
        this.removebufferbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.removebutton.tooltip", (String)"_rm tooltip_"));
        this.removebufferbutton.setIcon(this.loadIcon("docsynch.icons.removedoc"));
        this.removebufferbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DocSynchWindow.this.removebufferbuttonActionPerformed(event);
            }
        });
        panel.add((Component)this.removebufferbutton, "7, 3, f, f");
        this.doctableModel = new DocTableModel(this.ds.getDocuments());
        this.doctableModel.addTableModelListener(this);
        this.doctable = new JTable(this.doctableModel);
        this.doctable.getTableHeader().setReorderingAllowed(false);
        this.doctable.setSelectionMode(0);
        ColorDocumentTableCellRenderer colorCellRenderer = new ColorDocumentTableCellRenderer(this.ds);
        for (int i = 0; i < this.doctable.getModel().getColumnCount(); ++i) {
            this.doctable.getColumnModel().getColumn(i).setCellRenderer(colorCellRenderer);
        }
        this.doctable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                DocSynchWindow.this.doctableMouseClicked(event);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.doctable);
        scrollPane.setToolTipText(jEdit.getProperty((String)"docsynch.strings.doclist.tooltip", (String)"_doclist tooltip_"));
        panel.add((Component)scrollPane, "1, 5, 7, 5");
        TitledBorder title = BorderFactory.createTitledBorder(jEdit.getProperty((String)"docsynch.strings.docpanel.title", (String)"_documents_"));
        panel.setBorder(title);
        return panel;
    }

    protected JPanel createProgressPanel() {
        double[][] size = new double[][]{{5.0, -1.0, 5.0}, {3.0, 25.0, 3.0}};
        TableLayout layout = new TableLayout(size);
        JPanel panel = new JPanel(layout);
        this.progressBar = new JProgressBar();
        this.progressBar.setString(jEdit.getProperty((String)"docsynch.strings.dcc.nothing", (String)"_nothing_"));
        this.progressBar.setToolTipText(jEdit.getProperty((String)"docsynch.strings.progressbar.tooltip", (String)"_progressbar tooltip_"));
        this.progressBar.setStringPainted(true);
        panel.add((Component)this.progressBar, "1, 1, 1, 1");
        TitledBorder title = BorderFactory.createTitledBorder(jEdit.getProperty((String)"docsynch.strings.progresspanel.title", (String)"_progress_"));
        panel.setBorder(title);
        return panel;
    }

    public void connectionStatusChanged() {
        boolean connected = this.ds.inIRCChannel();
        boolean sessionRunning = this.ds.sessionRunning();
        String labelText = "";
        if (connected) {
            labelText = " [" + this.ds.getIRCServer() + "]";
        }
        boolean joined = this.ds.userJoined();
        boolean master = this.ds.getUsers().isMeMaster();
        boolean status_unknown = this.ds.statusUnknown();
        this.startbutton.setEnabled(!status_unknown && connected);
        this.addbufferbutton.setEnabled(joined && master || !sessionRunning);
        this.addallbuffersbutton.setEnabled(joined && master || !sessionRunning);
        this.removebufferbutton.setEnabled((joined && master || !sessionRunning) && this.doctableModel.getRowCount() > 0);
        this.lockModeBox.setEnabled(joined && master || !sessionRunning);
        this.mutexChanged();
        if (connected) {
            if (sessionRunning) {
                this.statuslabel.setText(jEdit.getProperty((String)"docsynch.strings.statuslabel.session", (String)"") + labelText);
                this.statuslabel.setBackground(Color.GREEN);
            } else {
                this.statuslabel.setText(jEdit.getProperty((String)"docsynch.strings.statuslabel.no_session", (String)"") + labelText);
                this.statuslabel.setBackground(Color.YELLOW);
            }
        } else {
            this.statuslabel.setText(jEdit.getProperty((String)"docsynch.strings.statuslabel.no_connection", (String)""));
            this.statuslabel.setBackground(this.normal_color);
        }
        if (joined) {
            if (master) {
                if (this.ds.getUsers().size() > 1) {
                    this.startbutton.setText(jEdit.getProperty((String)"docsynch.strings.startbutton.leave.caption", (String)"_leave_"));
                } else {
                    this.startbutton.setText(jEdit.getProperty((String)"docsynch.strings.startbutton.stop.caption", (String)"_stop_"));
                }
                this.startbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.startbutton.stop.tooltip", (String)"_stop tooltip_"));
            } else {
                this.startbutton.setText(jEdit.getProperty((String)"docsynch.strings.startbutton.leave.caption", (String)"_leave_"));
                this.startbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.startbutton.leave.tooltip", (String)"_leave tooltip_"));
            }
        } else if (master) {
            this.startbutton.setText(jEdit.getProperty((String)"docsynch.strings.startbutton.start.caption", (String)"_start_"));
            this.startbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.startbutton.start.tooltip", (String)"_start tooltip_"));
        } else {
            this.startbutton.setText(jEdit.getProperty((String)"docsynch.strings.startbutton.join.caption", (String)"_join_"));
            this.startbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.startbutton.join.tooltip", (String)"_join tooltip_"));
        }
    }

    public void lockModeChanged() {
    }

    public void mutexChanged() {
        if (!this.ds.sessionRunning() || !this.ds.userJoined()) {
            this.requestbutton.setEnabled(false);
        } else {
            this.doctableModel.updateMutex();
            int sel = this.doctable.getSelectedRow();
            if (sel != -1) {
                String mutexOwner = this.ds.getDocuments().get(sel).getMutexOwner();
                if (mutexOwner.equals("#")) {
                    this.requestbutton.setIcon(this.aquireMutexIcon);
                    this.requestbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.requestbutton.tooltip", (String)"_request tooltip_"));
                    this.requestbutton.setEnabled(true);
                } else if (mutexOwner.equals(this.ds.getUsers().getMe())) {
                    this.requestbutton.setIcon(this.releaseMutexIcon);
                    this.requestbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.requestbutton.tooltip2", (String)"_request tooltip_"));
                    this.requestbutton.setEnabled(true);
                } else {
                    this.requestbutton.setIcon(this.releaseMutexIcon);
                    this.requestbutton.setToolTipText(jEdit.getProperty((String)"docsynch.strings.requestbutton.tooltip2", (String)"_request tooltip_"));
                    this.requestbutton.setEnabled(false);
                }
            } else {
                this.requestbutton.setEnabled(false);
            }
        }
    }

    public void blockingChanged(boolean blocking) {
        if (blocking) {
            this.blockingLabel.setBackground(jEdit.getColorProperty((String)"docsynch.strings.blocking.bgcolor"));
            this.blockingLabel.setForeground(jEdit.getColorProperty((String)"docsynch.strings.blocking.fontcolor"));
            this.blockingLabel.setText(jEdit.getProperty((String)"docsynch.strings.blocking.on"));
        } else {
            this.blockingLabel.setBackground(null);
            this.blockingLabel.setForeground(null);
            this.blockingLabel.setText(jEdit.getProperty((String)"docsynch.strings.blocking.off"));
        }
    }

    public void dispose() {
        EditBus.removeFromBus((EBComponent)this);
    }

    public void progressBarLabelChanged(String text) {
        this.progressBar.setString(text);
    }

    public void progressBarMaximumChanged(int maximum) {
        this.progressBar.setMaximum(maximum);
    }

    public void progressBarValueChanged(int value) {
        this.progressBar.setValue(value);
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getSource() == this.doctableModel) {
            this.removebufferbutton.setEnabled((this.ds.userJoined() && this.ds.getUsers().isMeMaster() || !this.ds.sessionRunning()) && this.doctableModel.getRowCount() > 0);
        } else if (e.getSource() == this.usertableModel && this.ds.sessionRunning() && this.ds.userJoined() && this.ds.getUsers().isMeMaster()) {
            if (this.ds.getUsers().size() > 1) {
                this.startbutton.setText(jEdit.getProperty((String)"docsynch.strings.startbutton.leave.caption", (String)"_leave_"));
            } else {
                this.startbutton.setText(jEdit.getProperty((String)"docsynch.strings.startbutton.stop.caption", (String)"_stop_"));
            }
        }
    }

    public void addbufferbuttonActionPerformed(ActionEvent event) {
        this.ds.addDocument(((jEditEditor)this.ds.getEditor()).getEditorDocument((Buffer)this.bufferbox.getSelectedItem()), false);
        this.mutexChanged();
    }

    public void addallbuffersbuttonActionPerformed(ActionEvent event) {
        Buffer[] openBuffers = jEdit.getBuffers();
        for (int i = 0; i < openBuffers.length; ++i) {
            this.ds.addDocument(((jEditEditor)this.ds.getEditor()).getEditorDocument(openBuffers[i]), true);
        }
        this.mutexChanged();
    }

    public void removebufferbuttonActionPerformed(ActionEvent event) {
        int sel = this.doctable.getSelectedRow();
        if (sel != -1) {
            this.ds.removeDocument(sel);
            this.mutexChanged();
        }
    }

    public void startbuttonActionPerformed(ActionEvent event) {
        if (this.ds.userJoined()) {
            this.ds.leaveSession();
        } else {
            this.ds.startSession();
        }
    }

    public void requestbuttonActionPerformed(ActionEvent event) {
        int sel = this.doctable.getSelectedRow();
        if (sel != -1) {
            String mutexOwner = this.ds.getDocuments().get(sel).getMutexOwner();
            if (mutexOwner.equals("#")) {
                this.ds.requestMutex(this.ds.getDocuments().get(sel).getName());
            } else if (mutexOwner.equals(this.ds.getUsers().getMe())) {
                this.ds.releaseMutex(this.ds.getDocuments().get(sel).getName());
            }
        }
    }

    public void doctableMouseClicked(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event)) {
            this.mutexChanged();
            int sel = this.doctable.getSelectedRow();
            if (sel != -1) {
                if (event.getClickCount() == 1) {
                    this.view.setBuffer(((jEditBuffer)this.ds.getDocuments().get(sel).getEditorDocument()).getBuffer());
                    this.view.toFront();
                    this.view.getEditPane().requestFocus();
                } else if (event.getClickCount() == 2) {
                    this.requestbuttonActionPerformed(null);
                }
            }
        }
    }

    public void lockmodeboxitemclicked(ActionEvent event) {
        if (this.lockModeBox.getSelectedItem() != null) {
            LockModeComboBoxItem item = (LockModeComboBoxItem)this.lockModeBox.getSelectedItem();
            JOptionPane.showMessageDialog(null, "lock mode changed: " + item.toString());
        }
    }

    public Icon loadIcon(String propertyName) {
        String iconName = jEdit.getProperty((String)propertyName);
        if (iconName == null) {
            return null;
        }
        Icon returnValue = null;
        returnValue = iconName.startsWith("/") ? new ImageIcon((class$docsynch$gui$jedit$DocSynchWindow == null ? (class$docsynch$gui$jedit$DocSynchWindow = DocSynchWindow.class$("docsynch.gui.jedit.DocSynchWindow")) : class$docsynch$gui$jedit$DocSynchWindow).getResource(iconName)) : GUIUtilities.loadIcon((String)iconName);
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LockModeComboBoxItem {
        private DocSynch ds;
        private int lockMode;

        public LockModeComboBoxItem(DocSynch ds, int lockMode) {
            this.ds = ds;
            this.lockMode = lockMode;
        }

        public int getLockMode() {
            return this.lockMode;
        }

        public String toString() {
            switch (this.lockMode) {
                case 0: {
                    return jEdit.getProperty((String)"docsynch.strings.lockmode.realtime", (String)"_REAL TIME_");
                }
                case 1: {
                    return jEdit.getProperty((String)"docsynch.strings.lockmode.normal", (String)"_NORMAL LOCK_");
                }
                case 2: {
                    return jEdit.getProperty((String)"docsynch.strings.lockmode.auto", (String)"_AUTO LOCK_");
                }
                case 3: {
                    return jEdit.getProperty((String)"docsynch.strings.lockmode.master", (String)"_MASTER LOCK_");
                }
            }
            return jEdit.getProperty((String)"docsynch.strings.lockmode.normal", (String)"_NORMAL LOCK_");
        }
    }
}

