/*
 * Decompiled with CFR 0.152.
 */
package docsynch.gui.jedit;

import docsynch.external.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class DocSynchHighlightOptionPane
extends AbstractOptionPane {
    protected JCheckBox chActivate;
    protected JCheckBox chActivateTooltips;
    protected JCheckBox chFullLineEnds;
    protected JCheckBox chInvertForeground;
    protected JTable colorTable;
    protected UserColorModel colorModel;
    protected JButton add;
    protected JButton delete;
    protected JButton edit;
    private int y;
    private GridBagLayout gridBag;

    public DocSynchHighlightOptionPane() {
        super("docsynch.highlight");
    }

    protected void addCheckBox(JPanel panel, String property, JCheckBox chbox) {
        chbox.setText(jEdit.getProperty((String)("docsynch.strings." + property), (String)property));
        chbox.setToolTipText(jEdit.getProperty((String)("docsynch.strings." + property + ".tooltip"), (String)(property + ".tooltip")));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = new Insets(1, 0, 1, 0);
        this.gridBag.setConstraints(chbox, cons);
        panel.add(chbox);
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        JPanel checkboxes = new JPanel();
        this.gridBag = new GridBagLayout();
        checkboxes.setLayout(this.gridBag);
        this.y = 0;
        this.chActivate = new JCheckBox();
        this.chActivate.setSelected(jEdit.getBooleanProperty((String)"docsynch.settings.highlight.activate"));
        this.addCheckBox(checkboxes, "options.activate-highlighting", this.chActivate);
        this.chActivateTooltips = new JCheckBox();
        this.chActivateTooltips.setSelected(jEdit.getBooleanProperty((String)"docsynch.settings.highlight.activate-tooltip"));
        this.addCheckBox(checkboxes, "options.activate-tooltips", this.chActivateTooltips);
        this.chFullLineEnds = new JCheckBox();
        this.chFullLineEnds.setSelected(jEdit.getBooleanProperty((String)"docsynch.settings.highlight.draw-full-line-ends"));
        this.addCheckBox(checkboxes, "options.draw-full-line-ends", this.chFullLineEnds);
        this.chInvertForeground = new JCheckBox();
        this.chInvertForeground.setSelected(jEdit.getBooleanProperty((String)"docsynch.settings.highlight.invert-foreground-color"));
        this.addCheckBox(checkboxes, "options.invert-foreground", this.chInvertForeground);
        this.add("North", checkboxes);
        this.colorModel = new UserColorModel();
        this.colorTable = new JTable(this.colorModel);
        this.colorTable.getColumnModel().getColumn(1).setCellRenderer(new ColorCellRenderer());
        this.colorTable.setAutoResizeMode(4);
        this.colorTable.getTableHeader().setReorderingAllowed(false);
        this.colorTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.colorTable.getSelectionModel().setSelectionMode(0);
        this.colorTable.addMouseListener(new TableMouseHandler());
        JScrollPane scroller = new JScrollPane(this.colorTable);
        this.add("Center", scroller);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(6, 0, 0, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        this.add.setToolTipText(jEdit.getProperty((String)"docsynch.strings.options.add-button.tooltip"));
        this.add.addActionListener(actionHandler);
        buttons.add(this.add);
        this.delete = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        this.delete.setToolTipText(jEdit.getProperty((String)"docsynch.strings.options.remove-button.tooltip"));
        this.delete.addActionListener(actionHandler);
        buttons.add(this.delete);
        this.edit = new RolloverButton(GUIUtilities.loadIcon((String)"ButtonProperties.png"));
        this.edit.setToolTipText(jEdit.getProperty((String)"docsynch.strings.options.edit-button.tooltip"));
        this.edit.addActionListener(actionHandler);
        buttons.add(this.edit);
        buttons.add(Box.createGlue());
        this.add("South", buttons);
        this.updateEnabled();
    }

    protected void _save() {
        jEdit.setBooleanProperty((String)"docsynch.settings.highlight.activate", (boolean)this.chActivate.isSelected());
        jEdit.setBooleanProperty((String)"docsynch.settings.highlight.activate-tooltip", (boolean)this.chActivateTooltips.isSelected());
        jEdit.setBooleanProperty((String)"docsynch.settings.highlight.draw-full-line-ends", (boolean)this.chFullLineEnds.isSelected());
        jEdit.setBooleanProperty((String)"docsynch.settings.highlight.invert-foreground-color", (boolean)this.chInvertForeground.isSelected());
        this.colorModel.save();
    }

    private void updateEnabled() {
        int selectedRow = this.colorTable.getSelectedRow();
        this.edit.setEnabled(selectedRow != -1);
        this.delete.setEnabled(selectedRow != -1);
    }

    private void add() {
        EditUserColorDialog editDialog = new EditUserColorDialog(GUIUtilities.getParentDialog((Component)((Object)this)), "docsynch.strings.options.add-color-dialog.title", new UserColor("", Color.WHITE));
        if (editDialog.showModal()) {
            Log.debug((Object)((Object)this), (String)"added");
            this.colorModel.add(editDialog.getUserColor());
        }
    }

    private void edit(int index) {
        EditUserColorDialog editDialog = new EditUserColorDialog(GUIUtilities.getParentDialog((Component)((Object)this)), "docsynch.strings.options.edit-color-dialog.title", this.colorModel.get(index));
        if (editDialog.showModal()) {
            this.colorModel.replace(index, editDialog.getUserColor());
        }
    }

    private void delete(int index) {
        this.colorModel.remove(index);
        this.updateEnabled();
    }

    class EditUserColorDialog
    extends JDialog {
        private UserColor uc;
        private JTextField userTextField;
        private ColorWellButton colorButton;
        private JButton ok;
        private JButton cancel;
        private boolean okPressed;

        public EditUserColorDialog(Dialog dialog, String titleprop, UserColor uc) {
            super(dialog, jEdit.getProperty((String)titleprop), true);
            this.uc = uc;
            this.okPressed = false;
            this.init();
        }

        public UserColor getUserColor() {
            return this.uc.copy();
        }

        public boolean showModal() {
            this.show();
            return this.okPressed;
        }

        public void init() {
            JPanel content = new JPanel(new BorderLayout());
            content.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setContentPane(content);
            JPanel panel1 = new JPanel();
            panel1.setBorder(new EmptyBorder(0, 0, 10, 0));
            panel1.setLayout(new BorderLayout());
            JLabel labelUser = new JLabel(jEdit.getProperty((String)"docsynch.strings.options.tableheader.user") + ":  ");
            panel1.add("West", labelUser);
            this.userTextField = new JTextField(this.uc.user, 15);
            panel1.add("East", this.userTextField);
            content.add("North", panel1);
            JPanel panel2 = new JPanel();
            panel2.setBorder(new EmptyBorder(0, 0, 20, 0));
            panel2.setLayout(new BorderLayout());
            JLabel labelColor = new JLabel(jEdit.getProperty((String)"docsynch.strings.options.tableheader.color") + ":  ");
            panel2.add("West", labelColor);
            this.colorButton = new ColorWellButton(this.uc.color);
            panel2.add("Center", (Component)this.colorButton);
            content.add("Center", panel2);
            EditDialogActionHandler actionHandler = new EditDialogActionHandler();
            Box box = new Box(0);
            box.add(Box.createGlue());
            this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
            this.ok.addActionListener(actionHandler);
            this.getRootPane().setDefaultButton(this.ok);
            box.add(this.ok);
            box.add(Box.createHorizontalStrut(6));
            this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
            this.cancel.addActionListener(actionHandler);
            box.add(this.cancel);
            box.add(Box.createGlue());
            content.add("South", box);
            EditDialogKeyHandler listener = new EditDialogKeyHandler();
            this.addKeyListener(listener);
            this.userTextField.addKeyListener(listener);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        class EditDialogKeyHandler
        extends KeyAdapter {
            EditDialogKeyHandler() {
            }

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    EditUserColorDialog.this.dispose();
                }
            }
        }

        class EditDialogActionHandler
        implements ActionListener {
            EditDialogActionHandler() {
            }

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == EditUserColorDialog.this.ok) {
                    if (EditUserColorDialog.this.userTextField.getText() == null || EditUserColorDialog.this.userTextField.getText().equals("")) {
                        EditUserColorDialog.this.getToolkit().beep();
                        return;
                    }
                    ((EditUserColorDialog)EditUserColorDialog.this).uc.user = EditUserColorDialog.this.userTextField.getText();
                    ((EditUserColorDialog)EditUserColorDialog.this).uc.color = EditUserColorDialog.this.colorButton.getSelectedColor();
                    EditUserColorDialog.this.okPressed = true;
                }
                EditUserColorDialog.this.dispose();
            }
        }
    }

    class UserColor {
        public String user;
        public Color color;

        public UserColor(String user, Color color) {
            this.user = user;
            this.color = color;
        }

        public UserColor copy() {
            return new UserColor(new String(this.user), new Color(this.color.getRGB(), true));
        }
    }

    class UserColorModel
    extends AbstractTableModel {
        private Vector colors = new Vector();
        private boolean modified;

        UserColorModel() {
            int count = jEdit.getIntegerProperty((String)"docsynch.settings.highlight.colors.count", (int)0);
            for (int i = 0; i < count; ++i) {
                this.colors.add(new UserColor(jEdit.getProperty((String)("docsynch.settings.highlight.colors.user." + i)), jEdit.getColorProperty((String)("docsynch.settings.highlight.colors.col." + i))));
            }
            this.modified = false;
        }

        void save() {
            if (this.modified) {
                int i;
                int count = jEdit.getIntegerProperty((String)"docsynch.settings.highlight.colors.count", (int)0);
                for (i = 0; i < count; ++i) {
                    jEdit.unsetProperty((String)("docsynch.settings.highlight.colors.user." + i));
                    jEdit.unsetProperty((String)("docsynch.settings.highlight.colors.col." + i));
                }
                jEdit.setIntegerProperty((String)"docsynch.settings.highlight.colors.count", (int)this.colors.size());
                for (i = 0; i < this.colors.size(); ++i) {
                    UserColor uc = (UserColor)this.colors.get(i);
                    jEdit.setProperty((String)("docsynch.settings.highlight.colors.user." + i), (String)uc.user);
                    jEdit.setColorProperty((String)("docsynch.settings.highlight.colors.col." + i), (Color)uc.color);
                }
            }
        }

        void add(UserColor uc) {
            this.modified = true;
            this.colors.add(uc);
            this.fireTableRowsInserted(this.colors.size() - 1, this.colors.size() - 1);
        }

        void remove(int index) {
            this.modified = true;
            this.colors.removeElementAt(index);
            this.fireTableRowsDeleted(index, index);
        }

        void replace(int index, UserColor uc) {
            this.modified = true;
            this.colors.setElementAt(uc, index);
            this.fireTableRowsUpdated(index, index);
        }

        UserColor get(int index) {
            return (UserColor)this.colors.get(index);
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.colors.size();
        }

        public Object getValueAt(int row, int col) {
            UserColor uc = (UserColor)this.colors.elementAt(row);
            switch (col) {
                case 0: {
                    return uc.user;
                }
                case 1: {
                    return uc.color;
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return jEdit.getProperty((String)"docsynch.strings.options.tableheader.user");
                }
                case 1: {
                    return jEdit.getProperty((String)"docsynch.strings.options.tableheader.color");
                }
            }
            return null;
        }
    }

    class ColorCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Color) {
                cell.setBackground((Color)value);
                cell.setForeground((Color)value);
            }
            return cell;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == DocSynchHighlightOptionPane.this.add) {
                DocSynchHighlightOptionPane.this.add();
            } else if (source == DocSynchHighlightOptionPane.this.edit) {
                DocSynchHighlightOptionPane.this.edit(DocSynchHighlightOptionPane.this.colorTable.getSelectedRow());
            } else if (source == DocSynchHighlightOptionPane.this.delete) {
                DocSynchHighlightOptionPane.this.delete(DocSynchHighlightOptionPane.this.colorTable.getSelectedRow());
            }
        }
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            DocSynchHighlightOptionPane.this.updateEnabled();
        }
    }

    class TableMouseHandler
    extends MouseAdapter {
        TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                DocSynchHighlightOptionPane.this.edit(DocSynchHighlightOptionPane.this.colorTable.getSelectedRow());
            }
        }
    }
}

