/*
 * Decompiled with CFR 0.152.
 */
package docsynch.gui.jedit;

import docsynch.DocSynch;
import docsynch.Document;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.jEdit;

public class ColorDocumentTableCellRenderer
extends DefaultTableCellRenderer {
    protected DocSynch ds;
    protected Color originalColor;
    protected Color originalSelectedColor;

    public ColorDocumentTableCellRenderer(DocSynch ds) {
        this.ds = ds;
        this.originalColor = null;
        this.originalSelectedColor = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            if (this.originalSelectedColor == null) {
                this.originalSelectedColor = cell.getBackground();
            }
        } else if (this.originalColor == null) {
            this.originalColor = cell.getBackground();
        }
        if (jEdit.getBooleanProperty((String)"docsynch.settings.highlight.activate")) {
            Document doc = this.ds.getDocuments().get(row);
            if (!doc.getMutexOwner().equals("#")) {
                Color color = this.ds.getChangeColors().getColorFor(doc.getMutexOwner());
                cell.setBackground(color);
            } else if (isSelected) {
                cell.setBackground(this.originalSelectedColor);
            } else {
                cell.setBackground(this.originalColor);
            }
        }
        return cell;
    }
}

