/*
 * Decompiled with CFR 0.152.
 */
package docsynch.gui.jedit;

import docsynch.DocSynch;
import docsynch.Document;
import docsynch.external.jedit.jEditEditor;
import docsynch.highlight.ChangeBlock;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class ChangeHighlighter
extends TextAreaExtension {
    protected boolean enabled = false;
    protected boolean tooltipEnabled = false;
    protected JEditTextArea textArea;
    protected DocSynch ds;
    protected Point point;
    protected boolean drawFullLineEnds;
    protected String tooltipText;

    public ChangeHighlighter(JEditTextArea textArea, DocSynch ds) {
        this.textArea = textArea;
        this.ds = ds;
        this.point = new Point();
        this.propertiesChanged();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void propertiesChanged() {
        this.drawFullLineEnds = jEdit.getBooleanProperty((String)"docsynch.settings.highlight.draw-full-line-ends", (boolean)false);
        this.tooltipText = jEdit.getProperty((String)"docsynch.strings.highlight.tooltip");
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        ChangeBlock changes;
        Document doc;
        Buffer buffer;
        if (this.enabled && (buffer = this.textArea.getBuffer()).isLoaded() && physicalLine < buffer.getLineCount() && (doc = this.ds.getDocuments().get(((jEditEditor)this.ds.getEditor()).getEditorDocument(buffer))) != null && (changes = doc.getChangeManager().subset(start)) != null) {
            int offset = start;
            int lineHeight = this.textArea.getPainter().getFontMetrics().getHeight();
            for (ChangeBlock currentBlock = changes; offset < end && currentBlock != null; offset += currentBlock.length(), currentBlock = currentBlock.next()) {
                if (currentBlock.user().equals("#")) continue;
                this.paintBlock(physicalLine, offset, currentBlock.length(), end, this.ds.getChangeColors().getColorFor(currentBlock.user()), gfx, y, lineHeight);
            }
        }
    }

    protected void paintBlock(int physicalLine, int start, int blockLength, int endOfLine, Color color, Graphics2D gfx, int y, int lineHeight) {
        int lineOffset = start - this.textArea.getLineStartOffset(physicalLine);
        if (this.textArea.offsetToXY(physicalLine, lineOffset, this.point) != null) {
            int xStart = (int)this.point.getX();
            int xWidth = start + blockLength >= endOfLine ? (this.drawFullLineEnds ? this.textArea.getPainter().getWidth() - xStart : (this.textArea.offsetToXY(physicalLine, endOfLine - this.textArea.getLineStartOffset(physicalLine), this.point) != null ? (int)this.point.getX() - xStart + 2 : 0)) : (this.textArea.offsetToXY(physicalLine, lineOffset + blockLength, this.point) != null ? (int)this.point.getX() - xStart : 0);
            gfx.setColor(color);
            gfx.fillRect(xStart, y, xWidth, lineHeight);
        }
    }

    public String getToolTipText(int x, int y) {
        ChangeBlock change;
        Document doc;
        if (this.tooltipEnabled && (doc = this.ds.getDocuments().get(((jEditEditor)this.ds.getEditor()).getEditorDocument(this.textArea.getBuffer()))) != null && (change = doc.getChangeManager().getChangeAtOffset(this.textArea.xyToOffset(x, y))) != null && !change.user().equals("#")) {
            return change.length() + " " + this.tooltipText + " " + change.user();
        }
        return null;
    }
}

