/*
 * Decompiled with CFR 0.152.
 */
package docsynch.external.jedit;

import de.iqcomputing.jedit.irc.IRCMessageHandler;
import de.iqcomputing.jedit.irc.IRCPlugin;
import de.iqcomputing.jedit.irc.dcc.DCCFileEvent;
import de.iqcomputing.jedit.irc.dcc.DCCFileListener;
import docsynch.external.DCCEvent;
import docsynch.external.DCCListener;
import docsynch.external.IRCClient;
import docsynch.external.IRCListener;
import docsynch.external.Log;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.gjt.sp.jedit.jEdit;

public class jEditIRCClient
implements IRCClient,
IRCMessageHandler {
    protected IRCPlugin ircPlugin = null;
    protected Vector listeners = new Vector();

    public jEditIRCClient() {
        this.ircPlugin = (IRCPlugin)jEdit.getPlugin((String)"de.iqcomputing.jedit.irc.IRCPlugin");
        try {
            IRCPlugin.registerBot((IRCMessageHandler)this);
            Log.debug((Object)this, (String)"DocSynch is registered on IRCPlugin");
        }
        catch (Exception e) {
            this.ircPlugin = null;
            Log.debug((Object)this, (String)"Starting Thread waiting for IRCPlugin to come up");
            new Thread(new Runnable(){

                public void run() {
                    boolean done = false;
                    int count = 0;
                    while (!done) {
                        jEditIRCClient.this.ircPlugin = (IRCPlugin)jEdit.getPlugin((String)"de.iqcomputing.jedit.irc.IRCPlugin");
                        try {
                            IRCPlugin cfr_ignored_0 = jEditIRCClient.this.ircPlugin;
                            IRCPlugin.registerBot((IRCMessageHandler)jEditIRCClient.this);
                            Log.debug((Object)this, (String)"DocSynch is registered on IRCPlugin");
                            done = true;
                        }
                        catch (Exception e) {
                            jEditIRCClient.this.ircPlugin = null;
                        }
                        if (done) continue;
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                            if ((count += 100) <= 30000) continue;
                            Log.warning((Object)this, (String)"IRC Plugin was not started by jEdit - DocSynch cannot work. Please install IRCPlugin >= 2.0!");
                            done = true;
                        }
                        catch (InterruptedException ie) {
                            Log.error((Object)this, (Exception)ie);
                        }
                    }
                    Log.debug((Object)this, (String)"Temporary Thread done");
                }
            }).start();
        }
    }

    public void dispose() {
        if (this.ircPlugin == null) {
            return;
        }
        IRCPlugin.unregisterBot((IRCMessageHandler)this);
        Log.debug((Object)this, (String)"DocSynch has unregistered from IRCPlugin");
    }

    public boolean isConnected() {
        if (this.ircPlugin == null) {
            return false;
        }
        jEditIRCClient jEditIRCClient2 = this;
        return jEditIRCClient2.ircPlugin.isConnected();
    }

    public void inputHidden(String message) {
        if (this.ircPlugin == null) {
            return;
        }
        IRCPlugin.inputHidden((String)message);
    }

    public void inputHiddenTo(String to, String message) {
        if (this.ircPlugin == null) {
            return;
        }
        IRCPlugin.inputHiddenTo((String)to, (String)message);
    }

    public String getIRCServer() {
        if (this.ircPlugin == null) {
            return "";
        }
        jEditIRCClient jEditIRCClient2 = this;
        return jEditIRCClient2.ircPlugin.getServer();
    }

    public String getNickname() {
        if (this.ircPlugin == null) {
            return "";
        }
        jEditIRCClient jEditIRCClient2 = this;
        return jEditIRCClient2.ircPlugin.getNickname();
    }

    public void addIRCListener(IRCListener listener) {
        this.listeners.add(listener);
    }

    public void removeIRCListener(IRCListener listener) {
        this.listeners.remove(listener);
    }

    public boolean sendDCCFile(String to, File file, String sendFilename, boolean showMessages, DCCListener extraListener) {
        if (this.ircPlugin == null) {
            return false;
        }
        return IRCPlugin.sendDCCFile((String)to, (File)file, (String)sendFilename, (boolean)showMessages, (DCCFileListener)new DCCListenerAdapter(extraListener));
    }

    public void receiveDCCFile(String from, String orig_filename, File file, String hostip, String port, String filesize, boolean showMessages, DCCListener extraListener) {
        if (this.ircPlugin == null) {
            return;
        }
        IRCPlugin.receiveDCCFile((String)from, (String)orig_filename, (File)file, (String)hostip, (String)port, (String)filesize, (boolean)showMessages, (DCCFileListener)new DCCListenerAdapter(extraListener));
    }

    public boolean handlePublicMessage(String from, String message) {
        boolean notHandled = true;
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            notHandled = notHandled && ((IRCListener)enumeration.nextElement()).handleIRCMessage(from, message);
        }
        return notHandled;
    }

    public boolean handlePrivateMessage(String from, String message) {
        boolean notHandled = true;
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            notHandled = notHandled && ((IRCListener)enumeration.nextElement()).handleIRCMessage(from, message);
        }
        return notHandled;
    }

    public boolean handleDCCFileSend(String from, String filename, String hostip, String port, String filesize) {
        boolean notHandled = true;
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements() && notHandled) {
            notHandled = ((IRCListener)enumeration.nextElement()).handleDCCFileSend(from, filename, hostip, port, filesize);
        }
        return notHandled;
    }

    public void connectedToServer(String server) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((IRCListener)enumeration.nextElement()).connectedToServer(server);
        }
    }

    public void joinedChannel(String channel) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((IRCListener)enumeration.nextElement()).joinedChannel(channel);
        }
    }

    public void leftChannel() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((IRCListener)enumeration.nextElement()).leftChannel();
        }
    }

    public void userLeftChannel(String who) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((IRCListener)enumeration.nextElement()).userLeftChannel(who);
        }
    }

    public void disconnected() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((IRCListener)enumeration.nextElement()).disconnected();
        }
    }

    private class DCCEventAdapter
    implements DCCEvent {
        protected DCCFileEvent event;

        public DCCEventAdapter(DCCFileEvent event) {
            this.event = event;
        }

        public int getDirection() {
            return this.event.getDirection();
        }

        public int getType() {
            return this.event.getType();
        }

        public String getStringArg() {
            return this.event.getStringArg();
        }

        public int getIntArg() {
            return this.event.getIntArg();
        }

        public String getNick() {
            return this.event.getNick();
        }

        public String getFilename() {
            return this.event.getFilename();
        }

        public String getRealFilename() {
            return this.event.getRealFilename();
        }
    }

    private class DCCListenerAdapter
    implements DCCFileListener {
        protected DCCListener listener;

        public DCCListenerAdapter(DCCListener listener) {
            this.listener = listener;
        }

        public void fireDCCFileEvent(DCCFileEvent ev) {
            this.listener.fireDCCEvent((DCCEvent)new DCCEventAdapter(ev));
        }
    }
}

