/*
 * Decompiled with CFR 0.152.
 */
package docsynch.external.jedit;

import docsynch.external.DocumentChangeListener;
import docsynch.external.Editor;
import docsynch.external.EditorDocument;
import docsynch.external.EditorListener;
import docsynch.external.Log;
import docsynch.external.jedit.jEditBuffer;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferChangeAdapter;
import org.gjt.sp.jedit.buffer.BufferChangeListener;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;

public class jEditEditor
extends BufferChangeAdapter
implements Editor,
EBComponent,
KeyListener {
    protected Map buffers;
    protected Vector editorListeners;
    protected Vector docChangeListeners;

    public jEditEditor() {
        EditBus.addToBus((EBComponent)this);
        this.buffers = new Hashtable();
        Buffer[] initialBuffers = jEdit.getBuffers();
        for (int i = 0; i < initialBuffers.length; ++i) {
            this.addBufferToMap(initialBuffers[i]);
            initialBuffers[i].addBufferChangeListener((BufferChangeListener)this);
        }
        this.editorListeners = new Vector();
        this.docChangeListeners = new Vector();
    }

    public void dispose() {
        Iterator iter = this.buffers.keySet().iterator();
        while (iter.hasNext()) {
            ((Buffer)iter.next()).removeBufferChangeListener((BufferChangeListener)this);
        }
        this.buffers.clear();
        this.editorListeners.removeAllElements();
        this.docChangeListeners.removeAllElements();
        EditBus.removeFromBus((EBComponent)this);
    }

    protected EditorDocument addBufferToMap(Buffer buffer) {
        if (this.buffers.containsKey(buffer)) {
            return (EditorDocument)this.buffers.get(buffer);
        }
        jEditBuffer doc = new jEditBuffer(buffer, this);
        this.buffers.put(buffer, doc);
        return doc;
    }

    public EditorDocument getEditorDocument(Buffer buffer) {
        return (EditorDocument)this.buffers.get(buffer);
    }

    public void handleMessage(EBMessage message) {
        EditPaneUpdate epu;
        if (message instanceof BufferUpdate) {
            BufferUpdate bu = (BufferUpdate)message;
            if (bu.getWhat() == BufferUpdate.LOADED) {
                this.fireDocumentLoaded(this.getEditorDocument(bu.getBuffer()));
            } else if (bu.getWhat() == BufferUpdate.CREATED) {
                bu.getBuffer().addBufferChangeListener((BufferChangeListener)this);
                this.fireDocumentOpened(this.addBufferToMap(bu.getBuffer()));
            } else if (bu.getWhat() == BufferUpdate.CLOSED) {
                bu.getBuffer().removeBufferChangeListener((BufferChangeListener)this);
                this.fireDocumentClosed((EditorDocument)this.buffers.remove(bu.getBuffer()));
            } else if (bu.getWhat() == BufferUpdate.DIRTY_CHANGED) {
                this.resetReadOnlyFlag(bu.getBuffer(), bu.getView());
            }
        } else if (message instanceof EditPaneUpdate && (epu = (EditPaneUpdate)message).getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
            this.resetReadOnlyFlag(epu.getEditPane().getBuffer(), epu.getEditPane().getView());
        }
    }

    protected void resetReadOnlyFlag(Buffer buffer, View view) {
        EditorDocument doc = this.getEditorDocument(buffer);
        if (doc != null && doc.isReadOnly() && !buffer.isReadOnly()) {
            Log.message((Object)this, (String)("Setting buffer readonly again (cause it's a shared buffer): " + buffer));
            buffer.setReadOnly(true);
            EditBus.send((EBMessage)new BufferUpdate(buffer, view, BufferUpdate.DIRTY_CHANGED));
        }
    }

    protected void resetKeyInterceptor(Buffer buffer, View view) {
        EditorDocument doc = this.getEditorDocument(buffer);
        boolean autotype = true;
        if (doc != null && view != null) {
            KeyListener oldInterceptor = view.getKeyEventInterceptor();
            if (doc.isReadOnly() && autotype) {
                if (oldInterceptor != this && oldInterceptor == null) {
                    view.setKeyEventInterceptor((KeyListener)this);
                }
            } else if (oldInterceptor == this) {
                view.setKeyEventInterceptor(null);
            }
        }
    }

    protected void fireDocumentOpened(EditorDocument editorDoc) {
        Enumeration enumeration = this.editorListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((EditorListener)enumeration.nextElement()).documentOpened(editorDoc);
        }
    }

    protected void fireDocumentLoaded(EditorDocument editorDoc) {
        Enumeration enumeration = this.editorListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((EditorListener)enumeration.nextElement()).documentLoaded(editorDoc);
        }
    }

    protected void fireDocumentClosed(EditorDocument editorDoc) {
        Enumeration enumeration = this.editorListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((EditorListener)enumeration.nextElement()).documentClosed(editorDoc);
        }
    }

    protected void fireReadOnlyKeyEvent(char key) {
        Enumeration enumeration = this.editorListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((EditorListener)enumeration.nextElement()).readOnlyKeyEvent(key);
        }
    }

    public void contentInserted(Buffer buffer, int startLine, int offset, int numLines, int length) {
        Enumeration enumeration = this.docChangeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((DocumentChangeListener)enumeration.nextElement()).contentInserted(this.getEditorDocument(buffer), offset, length);
        }
    }

    public void contentRemoved(Buffer buffer, int startLine, int offset, int numLines, int length) {
        Enumeration enumeration = this.docChangeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((DocumentChangeListener)enumeration.nextElement()).contentRemoved(this.getEditorDocument(buffer), offset, length);
        }
    }

    public EditorDocument openFile(String filename) {
        Buffer buffer = jEdit.openFile((View)jEdit.getActiveView(), (String)filename);
        return this.addBufferToMap(buffer);
    }

    public void close(EditorDocument editorDoc) {
        jEdit.closeBuffer((View)jEdit.getActiveView(), (Buffer)((jEditBuffer)editorDoc).getBuffer());
    }

    public EditorDocument[] getOpenDocuments() {
        return (EditorDocument[])this.buffers.values().toArray();
    }

    public String[] saveFileDialog(String templateFilename) {
        return GUIUtilities.showVFSFileDialog((View)jEdit.getActiveView(), (String)templateFilename, (int)1, (boolean)false);
    }

    public void finishIORequests() {
        VFSManager.waitForRequests();
    }

    public void addEditorListener(EditorListener editorListener) {
        if (editorListener != null) {
            this.editorListeners.add(editorListener);
        }
    }

    public void removeEditorListener(EditorListener editorListener) {
        if (editorListener != null) {
            this.editorListeners.remove(editorListener);
        }
    }

    public void addDocumentsChangeListener(DocumentChangeListener docChangeListener) {
        if (docChangeListener != null) {
            this.docChangeListeners.add(docChangeListener);
        }
    }

    public void removeDocumentsChangeListener(DocumentChangeListener docChangeListener) {
        if (docChangeListener != null) {
            this.docChangeListeners.remove(docChangeListener);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        this.fireReadOnlyKeyEvent(e.getKeyChar());
    }

    public void keyReleased(KeyEvent e) {
    }

    public String getProperty(String name) {
        return jEdit.getProperty((String)name);
    }

    public String getProperty(String name, String def) {
        return jEdit.getProperty((String)name, (String)def);
    }

    public boolean getBooleanProperty(String name) {
        return jEdit.getBooleanProperty((String)name);
    }

    public boolean getBooleanProperty(String name, boolean def) {
        return jEdit.getBooleanProperty((String)name, (boolean)def);
    }

    public int getIntegerProperty(String name, int def) {
        return jEdit.getIntegerProperty((String)name, (int)def);
    }

    public Color getColorProperty(String name) {
        return jEdit.getColorProperty((String)name);
    }

    public void setProperty(String name, String value) {
        jEdit.setProperty((String)name, (String)value);
    }

    public void setBooleanProperty(String name, boolean value) {
        jEdit.setBooleanProperty((String)name, (boolean)value);
    }

    public void setIntegerProperty(String name, int value) {
        jEdit.setIntegerProperty((String)name, (int)value);
    }

    public void setColorProperty(String name, Color value) {
        jEdit.setColorProperty((String)name, (Color)value);
    }

    public void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    public String showInputDialog(String message, String def) {
        return JOptionPane.showInputDialog(null, message, def);
    }

    public boolean showConfirmDialog(String message, String title) {
        return JOptionPane.showConfirmDialog(null, message, title, 0) == 0;
    }
}

