/*
 * Decompiled with CFR 0.152.
 */
package docsynch.external.jedit;

import docsynch.external.Editor;
import docsynch.external.EditorDocument;
import docsynch.external.jedit.jEditEditor;
import java.io.File;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;

public class jEditBuffer
implements EditorDocument {
    protected jEditEditor editor;
    protected Buffer buffer;
    protected boolean readOnly;

    public jEditBuffer(Buffer buffer, jEditEditor editor) {
        this.buffer = buffer;
        this.editor = editor;
        this.readOnly = false;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public File getFile() {
        return new File(this.buffer.getPath());
    }

    public String getName() {
        return this.buffer.getName();
    }

    public String getPath() {
        return this.buffer.getPath();
    }

    public boolean isNewFile() {
        return this.buffer.isNewFile();
    }

    public boolean isLoaded() {
        return this.buffer.isLoaded();
    }

    public boolean equals(Object obj) {
        if (obj instanceof jEditBuffer) {
            return this.buffer == ((jEditBuffer)obj).getBuffer();
        }
        return false;
    }

    public void save() {
        this.buffer.save(jEdit.getActiveView(), null);
    }

    public void autosave() {
        this.buffer.autosave();
    }

    public File getAutosaveFile() {
        return this.buffer.getAutosaveFile();
    }

    public void insert(int offset, String text) {
        this.buffer.insert(offset, text);
    }

    public void remove(int offset, int length) {
        this.buffer.remove(offset, length);
    }

    public String getText(int offset, int length) {
        return this.buffer.getText(offset, length);
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    public void writeLock() {
        this.buffer.writeLock();
    }

    public void writeUnlock() {
        this.buffer.writeUnlock();
    }

    public void setMode(String mode) {
        if (!this.buffer.isLoaded()) {
            this.buffer.setStringProperty("mode", mode);
        } else {
            this.buffer.setMode(jEdit.getMode((String)mode));
        }
    }

    public String getMode() {
        return this.buffer.getMode().getName();
    }

    public boolean isDirty() {
        return this.buffer.isDirty();
    }

    public void setReadOnly(boolean readOnly, boolean updateUI) {
        this.readOnly = readOnly;
        this.buffer.setReadOnly(readOnly);
        if (updateUI) {
            EditBus.send((EBMessage)new BufferUpdate(this.buffer, jEdit.getActiveView(), BufferUpdate.DIRTY_CHANGED));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void scrollAllToOffset(int offset) {
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditPane[] editpanes = views[i].getEditPanes();
            for (int j = 0; j < editpanes.length; ++j) {
                if (this.buffer != editpanes[j].getBuffer()) continue;
                int line = this.buffer.getLineOfOffset(offset);
                editpanes[j].getTextArea().scrollTo(line, offset - this.buffer.getLineStartOffset(line), true);
            }
        }
    }
}

