/*
 * Decompiled with CFR 0.152.
 */
package docsynch;

import docsynch.DocSynch;
import docsynch.DocSynchListener;
import docsynch.Document;
import docsynch.external.Editor;
import docsynch.external.EditorDocument;
import docsynch.external.IRCClient;
import docsynch.external.Log;
import docsynch.external.jedit.jEditEditor;
import docsynch.external.jedit.jEditIRCClient;
import docsynch.external.jedit.jEditLogger;
import docsynch.gui.jedit.ChangeHighlighter;
import docsynch.gui.jedit.DocSynchGeneralOptionPane;
import docsynch.gui.jedit.DocSynchHighlightOptionPane;
import docsynch.gui.jedit.DocSynchWindow;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class DocSynchPlugin
extends EBPlugin
implements DocSynchListener {
    public static final String STRING_PREFIX = "docsynch.strings.";
    public static final String ICON_PREFIX = "docsynch.icons.";
    public static final String SETTING_PREFIX = "docsynch.settings.";
    protected Editor editor;
    protected IRCClient ircClient;
    protected DocSynch ds = null;
    protected Hashtable highlighterMap;

    public DocSynchWindow createWindow(View view, String position) {
        this.initDocSynch();
        return new DocSynchWindow(view, position, this.ds);
    }

    public void addHighlighter(EditPane editPane) {
        ChangeHighlighter highlighter = new ChangeHighlighter(editPane.getTextArea(), this.ds);
        this.highlighterMap.put(editPane, highlighter);
        editPane.getTextArea().getPainter().addExtension(-40, (TextAreaExtension)highlighter);
    }

    public void removeHighlighter(EditPane editPane, boolean removeFromMap) {
        editPane.getTextArea().getPainter().removeExtension((TextAreaExtension)((ChangeHighlighter)((Object)this.highlighterMap.get(editPane))));
        if (removeFromMap) {
            this.highlighterMap.remove(editPane);
        }
    }

    public void checkHighlighters() {
        Enumeration enumeration = this.highlighterMap.elements();
        while (enumeration.hasMoreElements()) {
            ChangeHighlighter highlighter = (ChangeHighlighter)((Object)enumeration.nextElement());
            highlighter.setEnabled(this.ds.sessionRunning() && this.ds.userJoined() && jEdit.getBooleanProperty((String)"docsynch.settings.highlight.activate"));
            highlighter.setTooltipEnabled(this.ds.sessionRunning() && this.ds.userJoined() && jEdit.getBooleanProperty((String)"docsynch.settings.highlight.activate-tooltip"));
        }
    }

    public boolean inIRCChannel() {
        return this.ds.inIRCChannel();
    }

    public String getIRCServer() {
        return this.ds.getIRCServer();
    }

    public boolean sessionRunning() {
        return this.ds.sessionRunning();
    }

    public boolean userJoined() {
        return this.ds.userJoined();
    }

    public boolean isMaster() {
        return this.ds.getUsers().isMeMaster();
    }

    public boolean statusUnknown() {
        return this.ds.statusUnknown();
    }

    public void toggleMutex(Buffer buffer) {
        Document doc = this.ds.getDocuments().get(((jEditEditor)this.editor).getEditorDocument(buffer));
        if (doc != null) {
            if (doc.getMutexOwner().equals("#")) {
                this.ds.requestMutex(doc.getName());
            } else if (doc.getMutexOwner().equals(this.ds.getUsers().getMe())) {
                this.ds.releaseMutex(doc.getName());
            }
        }
    }

    public void requestMutex(Buffer buffer) {
        Document doc = this.ds.getDocuments().get(((jEditEditor)this.editor).getEditorDocument(buffer));
        if (doc != null) {
            this.ds.requestMutex(doc.getName());
        }
    }

    public void releaseMutex(Buffer buffer) {
        Document doc = this.ds.getDocuments().get(((jEditEditor)this.editor).getEditorDocument(buffer));
        if (doc != null) {
            this.ds.releaseMutex(doc.getName());
        }
    }

    public boolean hasMutex(Buffer buffer) {
        Document doc = this.ds.getDocuments().get(((jEditEditor)this.editor).getEditorDocument(buffer));
        if (doc != null) {
            return doc.getMutexOwner().equals(this.ds.getUsers().getMe());
        }
        return false;
    }

    public void addBuffer(Buffer buffer) {
        if (buffer != null) {
            EditorDocument editorDoc = ((jEditEditor)this.editor).getEditorDocument(buffer);
            if (editorDoc != null) {
                this.ds.addDocument(editorDoc, false);
            }
            this.ds.updateMutex();
        }
    }

    public void addAllBuffers() {
        Buffer[] openBuffers = jEdit.getBuffers();
        for (int i = 0; i < openBuffers.length; ++i) {
            this.ds.addDocument(((jEditEditor)this.ds.getEditor()).getEditorDocument(openBuffers[i]), true);
        }
        this.ds.updateMutex();
    }

    public void removeBuffer(Buffer buffer) {
        int i;
        EditorDocument editorDoc;
        if (buffer != null && (editorDoc = ((jEditEditor)this.editor).getEditorDocument(buffer)) != null && (i = this.ds.getDocuments().indexOf(editorDoc)) != -1) {
            this.ds.removeDocument(i);
            this.ds.updateMutex();
        }
    }

    public void startSession() {
        if (!this.ds.userJoined()) {
            this.ds.startSession();
        }
    }

    public void stopSession() {
        if (this.ds.userJoined()) {
            this.ds.leaveSession();
        }
    }

    public void start() {
        this.initDocSynch();
        this.ds.addListener((DocSynchListener)this);
        this.highlighterMap = new Hashtable();
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditPane[] editPanes = views[i].getEditPanes();
            for (int j = 0; j < editPanes.length; ++j) {
                this.addHighlighter(editPanes[i]);
            }
        }
    }

    protected void initDocSynch() {
        if (this.ds == null) {
            Log.setLogger((Log)new jEditLogger());
            this.editor = new jEditEditor();
            this.ircClient = new jEditIRCClient();
            this.ds = new DocSynch(this.editor, this.ircClient, STRING_PREFIX, ICON_PREFIX, SETTING_PREFIX);
        }
    }

    public void stop() {
        Enumeration enumeration = this.highlighterMap.keys();
        while (enumeration.hasMoreElements()) {
            this.removeHighlighter((EditPane)enumeration.nextElement(), false);
        }
        this.highlighterMap.clear();
        this.editor.dispose();
        this.ircClient.dispose();
    }

    public void createMenuItems(Vector menuItems) {
        menuItems.addElement(GUIUtilities.loadMenu((String)"plugin.docsynch.DocSynchPlugin.menu"));
    }

    public void createOptionPanes(OptionsDialog optionsDialog) {
        OptionGroup og = new OptionGroup("docsynch");
        og.addOptionPane((OptionPane)new DocSynchGeneralOptionPane());
        og.addOptionPane((OptionPane)new DocSynchHighlightOptionPane());
        optionsDialog.addOptionGroup(og);
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)msg;
            if (epu.getWhat() == EditPaneUpdate.CREATED) {
                this.addHighlighter(epu.getEditPane());
                this.checkHighlighters();
            } else if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
                this.removeHighlighter(epu.getEditPane(), true);
            }
        } else if (msg instanceof PropertiesChanged) {
            this.ds.propertiesChanged();
            Enumeration enumeration = this.highlighterMap.elements();
            while (enumeration.hasMoreElements()) {
                ChangeHighlighter highlighter = (ChangeHighlighter)((Object)enumeration.nextElement());
                highlighter.propertiesChanged();
            }
            this.checkHighlighters();
        }
    }

    public void connectionStatusChanged() {
        this.checkHighlighters();
    }

    public void lockModeChanged() {
    }

    public void mutexChanged() {
    }

    public void blockingChanged(boolean blocking) {
    }

    public void dispose() {
    }
}

